package com.ediagnosis.cdr.dao;

import com.alibaba.fastjson.JSON;
import com.ediagnosis.cdr.CdrApplication;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSource;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataCollect.dao.mapper.BusinessDataSourceMapper;
import com.ediagnosis.cdr.model.dto.BusinessDataSourceDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataSourceQueryDTO;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * @author monojun
 * @description MapperTest
 * @createTime 2025年07月31日
 */
@SpringBootTest(classes = CdrApplication.class)
public class MapperTest {

    @Autowired
    private BusinessDataSourceMapper dataSourceMapper;

    @Test
    public void test1() {
        BusinessDataSourceQueryDTO queryDTO = new BusinessDataSourceQueryDTO();
        QueryWrapper queryWrapper = QueryWrapper.create()
                .select("d.*, ds.name as businessName")
                .from("business_data_source").as("d")
                .leftJoin("business_data_system").as("ds")
                .on("d.business_id = ds.id");
        Page<BusinessDataSourceDTO> dataSourceDTOPage = dataSourceMapper.paginateAs(1, 10, queryWrapper, BusinessDataSourceDTO.class);
        System.out.println(JSON.toJSON(dataSourceDTOPage));
    }

    @Test
    public void test2() {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .select("d.*", "ds.id as businessId, ds.name as businessName")
                .from(BusinessDataSource.class).as("d")
                .leftJoin(BusinessDataSystem.class).as("ds")
                .on(BusinessDataSource::getBusinessId, BusinessDataSystem::getId);
        queryWrapper.in(BusinessDataSource::getBusinessId, 1);

        Page<BusinessDataSourceDTO> dataSourceDTOPage = dataSourceMapper.paginateAs(1, 10, queryWrapper, BusinessDataSourceDTO.class);
        System.out.println(JSON.toJSON(dataSourceDTOPage));
    }
}
