package com.ediagnosis.cdr.service.impl;

import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSource;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataTable;
import com.ediagnosis.cdr.dataCollect.dao.mapper.BusinessDataTableMapper;
import com.ediagnosis.cdr.model.dto.BusinessDataTableDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataTableQueryDTO;
import com.ediagnosis.cdr.service.BusinessDataTableService;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author monojun
 * @description 业务表service
 * @createTime 2025年07月31日
 */
@Service
public class BusinessDataTableServiceImpl implements BusinessDataTableService {

    @Autowired
    private BusinessDataTableMapper dataTableMapper;

    @Override
    public Page<BusinessDataTableDTO> queryPage(BusinessDataTableQueryDTO queryDTO) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .select("t.*, d.id as sourceId, d.name as sourceName, ds.id as businessId, ds.name as businessName")
                .from(BusinessDataTable.class).as("t")
                .leftJoin(BusinessDataSource.class).as("d")
                .on(BusinessDataTable::getSourceId, BusinessDataSource::getId)
                .leftJoin(BusinessDataSystem.class).as("ds")
                .on(BusinessDataSource::getBusinessId, BusinessDataSystem::getId)
                .orderBy(BusinessDataTable::getId, false);
        if (StringUtils.hasText(queryDTO.getName())) {
            queryWrapper.like(BusinessDataTable::getName, queryDTO.getName());
        }
        if (!CollectionUtils.isEmpty(queryDTO.getBusinessIds())) {
            queryWrapper.in(BusinessDataTable::getBusinessId, queryDTO.getBusinessIds());
        }
        if (!CollectionUtils.isEmpty(queryDTO.getSourceIds())) {
            queryWrapper.in(BusinessDataTable::getSourceId, queryDTO.getSourceIds());
        }
        if (StringUtils.hasText(queryDTO.getTableNo())) {
            queryWrapper.like(BusinessDataTable::getTableNo, queryDTO.getTableNo());
        }
        return dataTableMapper.paginateAs(queryDTO.getPageNo(), queryDTO.getPageSize(), queryWrapper, BusinessDataTableDTO.class);
    }
}
