package com.ediagnosis.cdr.service.impl;

import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataCollect.dao.mapper.BusinessDataSystemMapper;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemQueryDTO;
import com.ediagnosis.cdr.service.BusinessDataSystemService;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * @author monojun
 * @description 业务系统service
 * @createTime 2025年07月31日
 */
@Service
public class BusinessDataSystemServiceImpl implements BusinessDataSystemService {

    @Autowired
    private BusinessDataSystemMapper dataSystemMapper;

    @Override
    public Long addDataSystem(BusinessDataSystemDTO dataSystemDTO) {
        BusinessDataSystem dataSystem = new BusinessDataSystem();
        BeanUtils.copyProperties(dataSystemDTO, dataSystem);
        dataSystem.setCreateTime(new Date());
        dataSystem.setUpdateTime(new Date());
        dataSystemMapper.insert(dataSystem);
        return dataSystem.getId();
    }

    @Override
    public Long updateDataSystem(BusinessDataSystemDTO dataSystemDTO) {
        BusinessDataSystem dataSystem = new BusinessDataSystem();
        BeanUtils.copyProperties(dataSystemDTO, dataSystem);
        dataSystem.setUpdateTime(new Date());
        dataSystemMapper.update(dataSystem);
        return dataSystem.getId();
    }

    @Override
    public void deleteDataSystem(Long dataSystemId) {
        dataSystemMapper.deleteById(dataSystemId);
    }

    @Override
    public Page<BusinessDataSystem> queryPage(BusinessDataSystemQueryDTO queryDTO) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        if (StringUtils.hasText(queryDTO.getName())) {
            queryWrapper.like(BusinessDataSystem::getName, queryDTO.getName());
        }
        queryWrapper.orderBy(BusinessDataSystem::getId, false);
        return dataSystemMapper.paginate(queryDTO.getPageNo(), queryDTO.getPageSize(), queryWrapper);
    }
}
