package com.ediagnosis.cdr.service;

import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemQueryDTO;
import com.mybatisflex.core.paginate.Page;

/**
 * @author monojun
 * @description 业务系统service
 * @createTime 2025年07月31日
 */
public interface BusinessDataSystemService {
    /**
     * 新增业务系统
     *
     * @param dataSystemDTO 业务系统dto
     * @return 主键id
     */
    Long addDataSystem(BusinessDataSystemDTO dataSystemDTO);

    /**
     * 更新业务系统
     *
     * @param dataSystemDTO 业务系统dto
     * @return Long
     */
    Long updateDataSystem(BusinessDataSystemDTO dataSystemDTO);

    /**
     * 删除业务系统
     *
     * @param dataSystemId 任务主键id
     */
    void deleteDataSystem(Long dataSystemId);

    /**
     * 分页查询业务系统信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataSystem>
     */
    Page<BusinessDataSystem> queryPage(BusinessDataSystemQueryDTO queryDTO);
}
