package com.ediagnosis.cdr.model.vo;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * @author monojun
 * @description 数据源信息
 * @createTime 2025年07月31日
 */
@Data
public class BusinessDataSourceVo implements Serializable {
    @Serial
    private static final long serialVersionUID = -4205114103165887164L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 数据源名称
     */
    private String name;

    /**
     * 数据源类型（mysql、oracle、postgreSQL、sqlserver、h2、sqlite）
     */
    private String type;

    /**
     * IP地址
     */
    private String ipAddress;

    /**
     * 业务系统id
     */
    private Long bizSystemId;

    /**
     * 业务系统名称
     */
    private String bizSystemName;

    /**
     * 描述
     */
    private String description;

    /**
     * 属性
     */
    private String properties;

    /**
     * 连接状态
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private Long createUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private Long updateUserId;
}
