package com.ediagnosis.cdr.dataCollect.dao;

import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataCollect.dao.mapper.BusinessDataSystemMapper;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemQueryDTO;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Date;
@Component
public class BizSystemDao {

    private final BusinessDataSystemMapper dataSystemMapper;

    public BizSystemDao(BusinessDataSystemMapper dataSystemMapper) {
        this.dataSystemMapper = dataSystemMapper;
    }


//  todo: 将page转换为pageVo,实体对象转换为业务对象

    public Page<BusinessDataSystem> queryPage(BusinessDataSystemQueryDTO queryDTO) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        if (StringUtils.hasText(queryDTO.getName())) {
            queryWrapper.like(BusinessDataSystem::getName, queryDTO.getName());
        }
        queryWrapper.orderBy(BusinessDataSystem::getId, false);
        return dataSystemMapper.paginate(queryDTO.getPageNo(), queryDTO.getPageSize(), queryWrapper);
    }
}
