package com.ediagnosis.cdr.controller;

import com.ediagnosis.cdr.model.dto.BusinessDataTableDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataTableQueryDTO;
import com.ediagnosis.cdr.model.param.BusinessDataTableQueryParam;
import com.ediagnosis.cdr.model.vo.BusinessDataTableVo;
import com.ediagnosis.cdr.service.BusinessDataTableService;
import com.ediagnosis.cdr.util.PageConvertUtils;
import com.ediagnosis.cdr.value.PageVo;
import com.ediagnosis.cdr.value.Response;
import com.mybatisflex.core.paginate.Page;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author monojun
 * @description 数据表接口
 * @createTime 2025年07月31日
 */
@RestController
@RequestMapping("/dataTable")
public class BusinessDataTableController {

    @Autowired
    private BusinessDataTableService dataTableService;

    @PostMapping("/page")
    public Response<PageVo<BusinessDataTableVo>> page(@RequestBody BusinessDataTableQueryParam queryParam) {
        BusinessDataTableQueryDTO queryDTO = new BusinessDataTableQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataTableDTO> dataTablePage = dataTableService.queryPage(queryDTO);
        PageVo<BusinessDataTableVo> dataTableVoPageInfo = PageConvertUtils.copyPageInfo(dataTablePage, dataTable -> {
            BusinessDataTableVo vo = new BusinessDataTableVo();
            BeanUtils.copyProperties(dataTable, vo);
            return vo;
        });
        return Response.success(dataTableVoPageInfo);
    }
}
