package com.ediagnosis.cdr.dashBoard;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DashBoardTest2 {
    public static void main(String[] args) throws Exception {

        System.out.println("cpu info:-----------------");
        System.out.println(getCpuUsage());
        System.out.println("memory info:-----------------");
        System.out.println(getMemoryUsage());
        System.out.println("disk info:-----------------");
        System.out.println(getDiskUsage());
    }



    public static Map<String, String> getCpuUsage() throws Exception {
        ProcessBuilder pb = new ProcessBuilder("top", "-bn1");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line;
        String cpuLine = "";
        String loadLine = "";
        while ((line = reader.readLine()) != null) {
            if (line.contains("load average:")) {
                loadLine = line;
            } else if (line.contains("Cpu(s)")) {
                cpuLine = line;
            }
            if (!cpuLine.isBlank() && !loadLine.isBlank()) {
                break;
            }
        }

        // 去掉前缀 "%Cpu(s):"，并提取数字
        String[] parts = cpuLine
                .replace("%Cpu(s):", "")
                .trim()
                .split(",");

        // 存储各个字段的值
        double id = 0;

        for (String part : parts) {
            part = part.trim();

            if (part.endsWith("id")) {
                id = Double.parseDouble(part.replace("id", "").trim());
            }

        }
        String cpuUsage = Math.round(100 - id)+ "%";
        String cpuCores = String.valueOf(
                Runtime.getRuntime().availableProcessors()
        );

        String loadAverage = "";
        // 正则匹配 "load average: 数值, 数值, 数值"
        Pattern pattern = Pattern.compile("load average: ([\\d.]+), ([\\d.]+), ([\\d.]+)");
        Matcher matcher = pattern.matcher(loadLine);

        if (matcher.find()) {
            double fiveMin = Double.parseDouble(matcher.group(2));
            loadAverage = String.valueOf(fiveMin);
        }


        // 方法一：100 - idle
        return Map.of(
                "cpuUsage", cpuUsage,
                "cpuCores", cpuCores,
                "loadAverage", loadAverage
        );
    }


    public static Map<String, String> getMemoryUsage() throws Exception {
        ProcessBuilder pb = new ProcessBuilder("free", "-h");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line;
        String memLine="";
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Mem:")) {
              memLine = line;
            }
        }

        // 将多个空格替换为单个空格，便于分割
        String[] parts = memLine.trim().replaceAll("\\s+", " ").split(" ");

        // 解析各字段（单位：KB、M、G）
        String totalStr = parts[1];
        String availableStr = parts[6];

        // 转换为统一单位（GB）
        double total = parseSizeToGB(totalStr);
        double available = parseSizeToGB(availableStr);

        // 计算内存使用率：(1 - available / total) * 100%
        double usagePercent = (1 - (available / total)) * 100;
        String memoryUsage =Math.round(usagePercent) +"%";
        String used=(total-available)+"G";
        String size=total+"G";
        String freee=available+"G";
        return Map.of(
                "used",used,
                "size",size,
                "freee",freee,
                "memoryUsage",memoryUsage
        );
    }
    private static double parseSizeToGB(String size) {
        double value = 0;
        if (size.endsWith("G")) {
            value = Double.parseDouble(size.replace("G", ""));
        } else if (size.endsWith("M")) {
            value = Double.parseDouble(size.replace("M", "")) / 1024;
        } else if (size.endsWith("K")) {
            value = Double.parseDouble(size.replace("K", "")) / (1024 * 1024);
        } else {
            value = Double.parseDouble(size) / (1024 * 1024 * 1024);
        }
        return value;
    }
    public static Map<String, String> getDiskUsage() throws Exception {
        ProcessBuilder pb = new ProcessBuilder("df", "-h", "/");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String header=reader.readLine();
        String body = reader.readLine();
        String[] parts = body.trim().replaceAll("\\s+", " ").split(" ");

        // 确保是有效行（至少有6列）
        if (parts.length < 6 || parts[4].indexOf('%') == -1) {
            throw new IllegalArgumentException("无效的磁盘使用行");
        }

        // 提取 Use% 字段（如 "69%"）
        String usePercent = parts[4];
        String size=parts[1];
        String free=parts[3];
        String used=parts[2];

        // 转换为整数
        return Map.of("usePercent", usePercent,
                "size", size,
                "free", free,
                "used", used);

    }


}
