package com.ediagnosis.cdr.dataIntegration;

import com.ediagnosis.cdr.CdrApplication;
import com.ediagnosis.cdr.dataIntegration.dao.BizDataDao;
import com.ediagnosis.cdr.dataIntegration.dao.dto.*;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BizSystem;
import com.mybatisflex.core.paginate.Page;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * @author monojun
 * @description TODO
 * @createTime 2025年08月06日
 */
@SpringBootTest(classes = CdrApplication.class)
public class DemoTest {

    @Autowired
    private BizDataDao bizDataDao;

    @Test
    public void test1() {
        BizTableQueryDTO queryDTO = new BizTableQueryDTO();
        Page<BizTableDTO> businessDataTableDTOPage = bizDataDao.queryTablePage(queryDTO);
        System.out.println(businessDataTableDTOPage);
    }

    @Test
    public void test2() {
        BizSystemQueryDTO queryDTO = new BizSystemQueryDTO();
        Page<BizSystem> dataSystemPage = bizDataDao.querySystemPage(queryDTO);
        System.out.println(dataSystemPage);
    }

    @Test
    public void test3() {
        Page<BizDataSourceDTO> dataSourceDTOPage = bizDataDao.querySourcePage(new BizDataSourceQueryDTO());
        System.out.println(dataSourceDTOPage);
    }

    @Test
    public void test4() {
        BizSystemDTO systemDTO = new BizSystemDTO();
        systemDTO.setId(4);
        systemDTO.setName("test");
        systemDTO.setDescription("test");
        bizDataDao.addOrUpdateBizSystem(systemDTO);

        BizSystemDTO systemDTO1 = new BizSystemDTO();
        systemDTO1.setName("test");
        systemDTO1.setDescription("test");
        bizDataDao.addOrUpdateBizSystem(systemDTO1);
    }


}
