package com.ediagnosis.cdr.maintenance.hostMonitor;

import com.ediagnosis.cdr.context.values.Response;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/host")
public class DashBoardController {

    private final HostMonitorValueRepository hostMonitorValueRepository;

    public DashBoardController(HostMonitorValueRepository hostMonitorValueRepository) {
        this.hostMonitorValueRepository = hostMonitorValueRepository;
    }


    @GetMapping("/list")
    public Response<List<HostMonitorValue.HostValue>> list() {
        HostMonitorValue.HostValue hostValue = hostMonitorValueRepository.getHostValue();
        return Response.success(List.of(hostValue));

    }

    @PostMapping("/monitor")
    public Response<List<HostMonitorValue>> monitor(String hostName) {

        HostMonitorValue hostMonitorValue = hostMonitorValueRepository.getHostMonitorValue(hostName);
        return Response.success(List.of(hostMonitorValue));
    }
}
