package com.ediagnosis.cdr.enums;

import lombok.Getter;

/**
 * @author monojun
 * @description 字段类型枚举
 * @createTime 2025年08月01日
 */
@Getter
public enum FieldTypeEnum {

    varchar("varchar", "String"),

    text("text", "String"),

    decimal("decimal", "BigDecimal"),

    integer("integer", "Integer"),

    int4("int4", "Integer"),

    int8("int8", "Integer"),

    number("number", "Long"),

    datetime("datetime", "Date"),

    timestamp("timestamp", "Date"),

    bool("boolean", "Boolean");


    private final String key;

    private final String value;


    FieldTypeEnum(String key, String value) {
        this.key = key;
        this.value = value;
    }
}
