package com.ediagnosis.cdr.dataIntegration.inner;

import com.ediagnosis.cdr.dataIntegration.dao.BizDataDao;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizTableDefinitionQueryDTO;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BizTableDefinition;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

/**
 * @author monojun
 * @description BizTableDefinitionRepository
 * @createTime 2025年08月06日
 */
@Repository
@RequiredArgsConstructor
public class BizTableDefinitionRepository {

    private final BizDataDao bizDataDao;

    /**
     * 分页查询源业务表字段信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BizTableDTO>
     */
    public Page<BizTableDefinition> queryPage(BizTableDefinitionQueryDTO queryDTO) {
        return bizDataDao.queryFieldPage(queryDTO);
    }
}
