package com.ediagnosis.cdr.dataIntegration.dao.entity;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.Data;

import java.io.Serializable;

/**
 * @author monojun
 * @description 业务表信息表
 * @createTime 2025年08月06日
 */
@Data
@Table(value = "biz_table")
public class BizTable implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id(value = "id", keyType = KeyType.Auto)
    private Integer id;

    /**
     * 业务表名称
     */
    @Column(value = "table_name")
    private String tableName;

    /**
     * 业务表编码
     */
    @Column(value = "table_code")
    private String tableCode;

    /**
     * 业务系统id
     */
    @Column(value = "biz_system_id")
    private Integer bizSystemId;

    /**
     * 业务数据源id
     */
    @Column(value = "biz_data_source_id")
    private Integer bizDataSourceId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;

    /**
     * 更新时间
     */
    @Column(value = "update_time")
    private String updateTime;
}