package com.ediagnosis.cdr.dataIntegration.dao.entity;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.Data;

import java.io.Serializable;

/**
 * @author monojun
 * @description 业务系统数据源表
 * @createTime 2025年08月06日
 */
@Data
@Table(value = "biz_data_source")
public class BizDataSource implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id(value = "id", keyType = KeyType.Auto)
    private Integer id;

    /**
     * 数据源名称
     */
    @Column(value = "name")
    private String name;

    /**
     * 数据源类型
     */
    @Column(value = "type")
    private String type;

    /**
     * IP地址
     */
    @Column(value = "ip")
    private String ip;

    /**
     * 属性信息
     */
    @Column(value = "properties")
    private String properties;

    /**
     * 业务系统id
     */
    @Column(value = "biz_system_id")
    private Integer bizSystemId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;

    /**
     * 更新时间
     */
    @Column(value = "update_time")
    private String updateTime;
}