package com.ediagnosis.cdr.dataIntegration;


import com.ediagnosis.cdr.context.PageConvertUtils;
import com.ediagnosis.cdr.context.values.PageVo;
import com.ediagnosis.cdr.context.values.Response;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizTableDefinitionQueryDTO;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BizTableDefinition;
import com.ediagnosis.cdr.dataIntegration.inner.BizTableDefinitionRepository;
import com.ediagnosis.cdr.dataIntegration.value.BizTableFieldVo;
import com.ediagnosis.cdr.dataIntegration.value.param.BizTableDefinitionQueryParam;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author monojun
 * @description 数据表字段定义
 * @createTime 2025年08月06日
 */
@RestController
@RequestMapping("/tableField")
@RequiredArgsConstructor
public class BizTableFieldController {

    private final BizTableDefinitionRepository definitionRepository;

    @PostMapping("/page")
    public Response<PageVo<BizTableFieldVo>> page(@RequestBody BizTableDefinitionQueryParam queryParam) {
        BizTableDefinitionQueryDTO queryDTO = new BizTableDefinitionQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BizTableDefinition> dataTableFieldPage = definitionRepository.queryPage(queryDTO);
        PageVo<BizTableFieldVo> tableFieldVoPageInfo = PageConvertUtils.copyPageInfo(dataTableFieldPage, dataTableField -> {
            BizTableFieldVo vo = new BizTableFieldVo();
            BeanUtils.copyProperties(dataTableField, vo);
            return vo;
        });
        return Response.success(tableFieldVoPageInfo);
    }


}
