package com.ediagnosis.cdr.dataIntegration;

import com.ediagnosis.cdr.context.PageConvertUtils;
import com.ediagnosis.cdr.context.values.PageVo;
import com.ediagnosis.cdr.context.values.Response;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizTableDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizTableQueryDTO;
import com.ediagnosis.cdr.dataIntegration.inner.BizTableRepository;
import com.ediagnosis.cdr.dataIntegration.value.BizTableVo;
import com.ediagnosis.cdr.dataIntegration.value.param.BizTableAddOrUpdateParam;
import com.ediagnosis.cdr.dataIntegration.value.param.BizTableDeleteParam;
import com.ediagnosis.cdr.dataIntegration.value.param.BizTableQueryParam;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author monojun
 * @description 源数据表controller
 * @createTime 2025年08月06日
 */
@RestController
@RequestMapping("/bizTable")
@RequiredArgsConstructor
public class BizTableController {

    private final BizTableRepository tableRepository;

    @PostMapping("/addOrUpdate")
    public Response<Integer> addOrUpdate(@RequestBody BizTableAddOrUpdateParam addOrUpdateParam) {
        BizTableDTO addDTO = new BizTableDTO();
        BeanUtils.copyProperties(addOrUpdateParam, addDTO);
        Integer id = tableRepository.addOrUpdateDataTable(addDTO);
        return Response.success(id);
    }


    @PostMapping("/page")
    public Response<PageVo<BizTableVo>> page(@RequestBody BizTableQueryParam queryParam) {
        BizTableQueryDTO queryDTO = new BizTableQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BizTableDTO> dataSystemPage = tableRepository.queryPage(queryDTO);
        PageVo<BizTableVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSystemPage, dataTableDTO -> {
            BizTableVo vo = new BizTableVo();
            BeanUtils.copyProperties(dataTableDTO, vo);
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }


    @PostMapping("/delete")
    public Response<List<Integer>> delete(@RequestBody BizTableDeleteParam deleteParam) {
        tableRepository.deleteDataSystem(deleteParam.getIds());
        return Response.success(deleteParam.getIds());
    }
}
