package com.ediagnosis.cdr.dataIntegration;

import com.ediagnosis.cdr.context.PageConvertUtils;
import com.ediagnosis.cdr.context.values.PageVo;
import com.ediagnosis.cdr.context.values.Response;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizDataSourceDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizDataSourceQueryDTO;
import com.ediagnosis.cdr.dataIntegration.inner.BizSourceRepository;
import com.ediagnosis.cdr.dataIntegration.value.BizDataSourceVo;
import com.ediagnosis.cdr.dataIntegration.value.param.BizSourceAddOrUpdateParam;
import com.ediagnosis.cdr.dataIntegration.value.param.BizSourceQueryParam;
import com.ediagnosis.cdr.dataIntegration.value.param.BizSystemDeleteParam;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author monojun
 * @description 数据源
 * @createTime 2025年08月06日
 */
@RestController
@RequestMapping("/bizSource")
@RequiredArgsConstructor
public class BizSourceController {

    private final BizSourceRepository sourceRepository;


    @PostMapping("/addOrUpdate")
    public Response<Integer> addOrUpdate(@RequestBody BizSourceAddOrUpdateParam addOrUpdateParam) {
        BizDataSourceDTO addDTO = new BizDataSourceDTO();
        BeanUtils.copyProperties(addOrUpdateParam, addDTO);
        Integer id = sourceRepository.addDataSource(addDTO);
        return Response.success(id);
    }


    @PostMapping("/page")
    public Response<PageVo<BizDataSourceVo>> page(@RequestBody BizSourceQueryParam queryParam) {
        BizDataSourceQueryDTO queryDTO = new BizDataSourceQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BizDataSourceDTO> dataSystemPage = sourceRepository.queryPage(queryDTO);
        PageVo<BizDataSourceVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSystemPage, dataSystem -> {
            BizDataSourceVo vo = new BizDataSourceVo();
            BeanUtils.copyProperties(dataSystem, vo);
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }


    @PostMapping("/delete")
    public Response<List<Integer>> delete(@RequestBody BizSystemDeleteParam deleteParam) {
        sourceRepository.deleteDataSource(deleteParam.getIds());
        return Response.success(deleteParam.getIds());
    }

}
