package com.ediagnosis.cdr.dataService;


import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.row.Row;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;

@Component
public class HiveQueryExecutor {

    public Page<Row> selectByFullSql(String fullSql, int pageNo, int pageSize) {
        Page<Row> page = new Page<>(pageNo, pageSize);
        Optional<String> countSql = SqlParser.getCountSql(fullSql);
        String limitSql = SqlParser.addLimitClause(fullSql);
        try {
            DataSourceKey.use("ds-hive");
            if(countSql.isPresent()){
                long count = Db.selectCount(countSql.get());
                page.setTotalRow(count);
            }

            List<Row> rows = Db.selectListBySql(limitSql);
            page.setRecords(rows);

        } finally {
            DataSourceKey.clear();
        }

        return page;
    }

}
