package com.ediagnosis.cdr.dashBoard.statistics.impl;

import com.ediagnosis.cdr.dashBoard.statistics.StatisticsService;
import org.springframework.stereotype.Service;

@Service
public class CacheableStatisticsService implements StatisticsService {

private final AbstractRowCountService rowCountService;
private final AbstractDataSourceCountService dataSourceCountService;
private final AbstractSourceBizTableCountService sourceBizTableCountService;




    public CacheableStatisticsService() {
        this.rowCountService = new AbstractRowCountService(){
            @Override
            public int getDataSourceCount() {
                return 0;
            }

            @Override
            public int getSourceBizTableCount() {
                return 0;
            }
        };
        this.dataSourceCountService =new AbstractDataSourceCountService(){
            @Override
            public long getRowCount() {
                return 0;
            }

            @Override
            public int getSourceBizTableCount() {
                return 0;
            }
        } ;
        this.sourceBizTableCountService = new AbstractSourceBizTableCountService() {
            @Override
            public long getRowCount() {
                return 0;
            }

            @Override
            public int getDataSourceCount() {
                return 0;
            }
        };
    }


    @Override
    public long getRowCount() {



        return rowCountService.getRowCount();
    }

    @Override
    public int getDataSourceCount() {
        return dataSourceCountService.getDataSourceCount();
    }

    @Override
    public int getSourceBizTableCount() {
        return sourceBizTableCountService.getSourceBizTableCount();
    }
}
