package com.ediagnosis.cdr.context.value;

import java.util.List;

public class Page<T> {
    private long pageNo;
    private long pageSize;
    private long totalCount;
    private List<T> content;
    private long totalPage;

    public Page() {
    }

    public Page(long pageNo, long pageSize,
                long totalCount, List<T> content) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.content = content;
        long tmp=totalCount / pageSize;
        long tmp1=totalCount % pageSize;
        if (tmp1>0) {
            this.totalPage = tmp+1;
        }else {
            this.totalPage = tmp;
        }

    }


    public long getPageNo() {
        return pageNo;
    }


    public long getPageSize() {
        return pageSize;
    }


    public long getTotalCount() {
        return totalCount;
    }


    public long getTotalPage() {
        return totalPage;
    }


    public List<T> getContent() {
        return content;
    }

    public void setPageNo(long pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }


}
