import request from '../util/ajax'

export function login(params) {
  return request({
    url: '/api/team/login',
    method: 'POST',
    data: params
  })
}

export function queryDictionaryList(params) {
  return request({
    url: '/api/team/dictionary/queryDictionaryList',
    method: 'POST',
    data: params
  })
}

export function queryEmergencyHospitalList(params) {
  return request({
    url: '/api/team/hospital/queryEmergencyHospitalList',
    method: 'POST',
    data: params
  })
}

export function queryHospitalList(name = "") {
  return request({
    url: '/api/team/hospital/queryHospitalList',
    method: 'GET',
    params: {
      name: name
    }
  })
}

export function queryExtendConfig(params) {
  return request({
    url: '/api/team/extend/queryExtendConfig',
    method: 'POST',
    data: params
  })
}

export function queryEmergencyResource(params) {
  return request({
    url: '/api/team/site/queryEmergencyResource',
    method: 'POST',
    data: params
  })
}

export function getServerInfo(params) {
  return request({
    url: '/api/team/base/getServerInfo',
    method: 'POST',
    data: params
  })
}

export function queryResourceList(params) {
  return request({
    url: '/api/team/resource/queryResourceList',
    method: 'POST',
    data: params
  })
}

export function exportEmergencyResources(params) {
  return request({
    url: '/api/team/base/exportEmergencyResources',
    method: 'POST',
    data: params
  })
}
