import IdentityCodeValid from '@/util/checkIdent'

let valiRule = {
  int: /^\d+(\.\d+)?$/, //整数和小数
  decInt: /^\d+$|^\d*\.\d+$/g, //正整数加小数
};

export const identityNumberCheck = (rule, value, callback) => {
  if (value && !IdentityCodeValid(value.toUpperCase())) {
    callback(new Error("请输入正确格式的身份证号"))
  } else {
    callback()
  }
};

export const onsetTimeLengthCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error())
  } else {
    callback()
  }
};


export const burnAreaCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error())
  } else {
    callback()
  }
};

export const breathingCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 0 && value <= 200) {
      callback()
    } else {
      callback(new Error());
    }
  }
};

export const pulseCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 0 && value <= 200) {
      callback()
    } else {
      callback(new Error());
    }
  }
};

export const bodyTemperatureCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 20 && value <= 50) {
      callback()
    } else {
      callback(new Error());
    }
  }
};

export const bloodOxygenSaturationCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 0 && value <= 100) {
      callback()
    } else {
      callback(new Error());
    }
  }
};

export const bloodSugarCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 0 && value <= 30) {
      callback()
    } else {
      callback(new Error());
    }
  }
};

export const heightCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 100 && value <= 220) {
      callback()
    } else {
      callback(new Error());
    }
  }
};

export const weightCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 0 && value <= 220) {
      callback()
    } else {
      callback(new Error());
    }
  }
};

export const bloodPressureCheck = (rule, value, callback) => {
  if (!valiRule.int.test(value) && value) {
    callback(new Error());
  } else {
    if (!value) {
      callback()
    } else if (value >= 0 && value <= 300) {
      callback()
    } else {
      callback(new Error());
    }
  }
}
