import Cookies from 'js-cookie'
import storage from 'good-storage'

const Cache = {
  MENUMAP: 'menuMap',
  USERINFO: 'userInfo',
  setMenuMap: function(menuMap) {
    storage.set(this.MENUMAP, menuMap)
    return menuMap
  },
  getMenuMap: function() {
    return storage.get(this.MENUMAP, '')
  },
  clearMenuMap: function() {
    storage.remove(this.MENUMAP)
    return ''
  },
  setUserInfo: function(userInfo) {
    storage.set(this.USERINFO, userInfo)
    return userInfo
  },
  getUserInfo: function() {
    return storage.get(this.USERINFO, '')
  },
  clearUserInfo: function() {
    storage.remove(this.USERINFO)
    return ''
  }
}

const Auth = {
  // 在Cookie中记录登录状态的key
  loginKey: 'userInfo',

  // 当前是否是登录状态
  getLoginInfo: function() {
    return Cookies.get(this.loginKey)
  },

  // 设置登录状态
  setLoginInfo: function(obj) {
    // TODO: 设置超时登录时间，在该时间范围内没有任何请求操作则自动删除
    var maxAge = new Date(new Date().getTime() + 30 * 60 * 1000)
    Cookies.set(this.loginKey, obj, {
      expires: maxAge
    })
    Cookies.set(this.loginKey, obj)
    return obj
  },

  // 移除登录状态
  clearLoginInfo: function() {
    Cookies.remove(this.loginKey)
  },

  // 免登录
  getNoLoginStr: function() {
    return Cookies.get('noLoginStr')
  },

  // 设置登录状态
  setNoLoginStr: function(obj) {
    Cookies.set('noLoginStr', obj)
    return obj
  },

  clearNoLoginStr: function() {
    Cookies.remove('noLoginStr')
  }
}

export {
  Auth,
  Cache
}
