import * as types from './mutation-types'
import {
  Cache,
  Auth
} from '@/util/auth'
import {
  login
} from '../api/common'
export const clearStore = function({
  commit,
  state
}) {
  commit(types.SET_MENUMAP, Cache.clearMenuMap())
  commit(types.SET_USERINFO, Cache.clearUserInfo())
  Auth.clearLoginInfo()
}
import {
  routeHandle
} from '../router/staticRoute'
import router from '../router'
export const saveMenuMap = function({
  commit
}, data) {
  commit(types.SET_MENUMAP, Cache.setMenuMap(data))
}

export const saveUserInfo = function({
  commit
}, data) {
  commit(types.SET_USERINFO, Cache.setUserInfo(data))
}

export const saveLoginMsg = function({
  commit
}, data) {
  const {
    menuMap: {
      parentMenuList
    },
    token,
    noLoginStr,
    userDto
  } = data.respData;
  commit(types.SET_MENUMAP, Cache.setMenuMap(parentMenuList))
  commit(types.SET_USERINFO, Cache.setUserInfo(userDto))
  Auth.setLoginInfo(token)
  Auth.setNoLoginStr(noLoginStr)
  router.addRoutes(routeHandle(parentMenuList))
}

export const LoginByToken = function({
  commit
}, data) {
  return new Promise(async (resolve, reject) => {
    const res = await login({
      token: data
    })
    const {
      menuMap: {
        parentMenuList
      },
      token,
      userDto
    } = res.respData;
    if (res.msg === 201 && parentMenuList && parentMenuList.length > 0) {
      await commit(types.SET_MENUMAP, Cache.setMenuMap(parentMenuList))
      await commit(types.SET_USERINFO, Cache.setUserInfo(userDto))
      Auth.setLoginInfo(token)
      Auth.clearNoLoginStr()
      router.addRoutes(routeHandle(parentMenuList))
      resolve()
    } else {
      reject()
    }
  })
}
