const Layout = () => import('../page/layout')

const staticRoute = [
  {
    path: '/',
    redirect: '/resources/emergencyCar'
  },
  {
    path: '/error',
    component: () => import('../page/error'),
    children: [
      {
        path: '401',
        component: () => import('../page/error/401')
      },
      {
        path: '403',
        component: () => import('../page/error/403')
      },
      {
        path: '404',
        component: () => import('../page/error/404')
      },
      {
        path: '500',
        component: () => import('../page/error/500')
      }
    ]
  },
  {
    path: '/bigscreen',
    component: () => import('../page/bigscreen/index')
  },
  {
    path: '/info',
    component: () => import('../page/info/index')
  },
  {
    path: '/business/hospital/detail',
    component: () => import('../page/hospital/detail')
  },
  {
    path: '/data',
    component: () => import('../page/data')
  },
  {
    path: '/data/detail',
    component: () => import('../page/data/detail')
  }
]
const routeHandle = (map) => {
  const routers = []
  map.forEach(item => {
    if(item.secondMenuList && item.secondMenuList.length > 0) {
      const children = []
      item.secondMenuList.forEach(_item => {
        children.push({
          path: _item.url,
          component: () => import(`@/page/${_item.keyName}`)
        })
      })
      routers.push({
        path: item.url,
        component: Layout,
        children: children
      })
    }
  });
  return routers
}

export {
  staticRoute,
  routeHandle
}
