// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import 'babel-polyfill'
import Vue from 'vue'
import App from './App'
import router from './router'
import ElementUI from 'element-ui';
import store from './store'
import axios from './util/ajax'
import checkPermission from './util/permission'
import 'sysStatic/css/theme-default-new.scss'
import './components/install'
import {
  message
} from './util/resetMessage';

Vue.config.productionTip = false
Vue.prototype.$axios = axios;
Vue.use(ElementUI)
Vue.prototype.$message = message;
Vue.prototype.checkPermission = checkPermission
/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  axios,
  store,
  components: {
    App
  },
  template: '<App/>'
})
