import request from '../util/ajax'

export function queryIntegrationList(params) {
  return request({
    url: '/api/team/pre/queryIntegrationList',
    method: 'POST',
    data: params
  })
}

export function queryDetail(params) {
  return request({
    url: '/api/team/pre/queryInfoById',
    method: 'POST',
    data: params
  })
}


export function savePreInfo(type, params) {
  let url = ''
  if (type === 'add') {
    url = '/api/team/pre/insertPreInfo'
  } else if (type === 'update') {
    url = '/api/team/pre/updatePreInfo'
  }
  return request({
    url: url,
    method: 'POST',
    data: params
  })
}
export function insertPreInfo(params) {
  return request({
    url: '/api/team/pre/insertPreInfo',
    method: 'POST',
    data: params
  })
}

export function updatePreInfo(params) {
  return request({
    url: '/api/team/pre/updatePreInfo',
    method: 'POST',
    data: params
  })
}

export function constructionStatistics(params){
    return request({
      url: '/api/team/report/constructionStatistics',
      method: 'POST',
      data: params
    })
}
export function businessTeamStatistics(params){
  return request({
    url: '/api/team/report/businessTeamStatistics',
    method: 'POST',
    data: params
  })
}
export function businessOperationStatistics(params){
  return request({
    url: '/api/team/report/businessOperationStatistics',
    method: 'POST',
    data: params
  })
}
export function queryHospitalList(params,str,area){
  return request({
    url:`/api/team/hospital/queryHospitalList?name=${str?str:''}&area=${area?area:''}`,
    method: 'GET',
    data: params
  })
}

export function getList(params){
  return request({
    url:`/api/team/importExcel/getList`,
    method: 'POST',
    data: params
  })
}

export function uploadExcel(params){
  return request({
    url:`/api/team/importExcel/uploadExcel`,
    method: 'POST',
    data: params
  })
}